<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo de conexión
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Verificar si el array es válido y contiene un ID
if (!is_array($datos) || !isset($datos[0])) {
    error_log("⚠️ Parámetros de entrada inválidos.");
    http_response_code(400);
    echo json_encode(["error" => "Parámetros de entrada inválidos"], JSON_UNESCAPED_UNICODE);
    exit();
}

$id = (int) $datos[0]; // Asegurar que sea un entero

try {
    $sql = "SELECT * FROM almacenes WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Verificar si hay datos
    if (!$rows) {
        error_log("⚠️ No se encontraron almacenes con ese ID.");
        echo json_encode([]);
    } else {
        echo json_encode($rows, JSON_UNESCAPED_UNICODE);
    }
} catch (PDOException $e) {
    error_log("❌ Error en la consulta: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(["error" => "Error interno del servidor"], JSON_UNESCAPED_UNICODE);
}

// Cerrar la conexión
$conn = null;
?>
