<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 5) {
        throw new Exception("Parámetros incompletos. Se requieren 5 datos.");
    }

    $sql = "SELECT * FROM im_almacen(:c_nombre, :c_empresa_id, :c_sucursal_id, :n_id_alm, :estado)";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':c_nombre', $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':c_empresa_id', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':c_sucursal_id', $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':n_id_alm', $datos[3], PDO::PARAM_INT);
    $stmt->bindValue(':estado', $datos[4], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($datos[4] === "NUEVO") {
        if ($result && isset($result['id_almacen']) && $result['id_almacen'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['id_almacen'],
                "MENSAJE" => "LA INFORMACION GUARDO CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACION"
            ];
        }
    } else {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => "0",
            "MENSAJE" => "LA INFORMACION ACTUALIZO CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
