<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 4) {
        throw new Exception("Parámetros insuficientes.");
    }

    // Preparar la consulta SQL asegurando que el alias se devuelva en minúsculas
    $sql = "SELECT anular_movcaja(:movcaja_id, :estado, :empresa_id, :sucursal_id) AS idmovcaja";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':movcaja_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':estado',      $datos[1], PDO::PARAM_BOOL);
    $stmt->bindValue(':empresa_id',  $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $datos[3], PDO::PARAM_INT);

    $stmt->execute();

    // Forzar las claves a minúsculas para evitar errores
    $resultadoBD = array_change_key_case($stmt->fetch(PDO::FETCH_ASSOC), CASE_LOWER);

    if ($resultadoBD && isset($resultadoBD['idmovcaja']) && $resultadoBD['idmovcaja'] > 0) {
        $resultado = [
            'ESTADO' => $datos[1] ? "1" : "0",
            'ID'     => $resultadoBD['idmovcaja'],
            'MENSAJE' => $datos[1] ? "SE ANULÓ CORRECTAMENTE" : "SE RECUPERÓ CORRECTAMENTE"
        ];
    } else {
        $resultado = [
            'ESTADO' => "0",
            'MENSAJE' => "No se realizó ninguna modificación."
        ];
    }

    echo json_encode($resultado, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}