<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=UTF-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    // Validar parámetros esperados (9 en total)
    if (count($datos) < 9) {
        throw new Exception("Parámetros incompletos.");
    }

    // Ejecutar función en PostgreSQL (retorna nRegistros)
    $stmt = $conn->prepare("SELECT * FROM cierre_caja(:empresa_id, :sucursal_id, :caja_id, :fecha_cierre, :hora_cierre, :usuario_cierre, :monto_total, :turno_id, :estado)");

    $stmt->bindParam(':empresa_id',    $datos[0], PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id',   $datos[1], PDO::PARAM_INT);
    $stmt->bindParam(':caja_id',       $datos[2], PDO::PARAM_INT);
    $stmt->bindParam(':fecha_cierre',  $datos[3], PDO::PARAM_STR);
    $stmt->bindParam(':hora_cierre',   $datos[4], PDO::PARAM_STR);
    $stmt->bindParam(':usuario_cierre',$datos[5], PDO::PARAM_STR);
    $stmt->bindParam(':monto_total',   $datos[6]);
    $stmt->bindParam(':turno_id',      $datos[7], PDO::PARAM_INT);
    $stmt->bindParam(':estado',        $datos[8], PDO::PARAM_INT);

    $stmt->execute();
    $mensaje = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($mensaje && $mensaje['nregistros'] > 0) {
        $resultado = [
            'ESTADO'    => "1",
            'REGISTROS' => $mensaje['nregistros'],
            'MENSAJE'   => "LA INFORMACION SE ACTUALIZO CORRECTAMENTE"
        ];
    } else {
        $resultado = [
            'ESTADO'    => "0",
            'REGISTROS' => "0",
            'MENSAJE'   => "NO SE ACTUALIZÓ NINGÚN REGISTRO"
        ];
    }

} catch (Exception $e) {
    $resultado = [
        'MENSAJE' => "ERROR: " . $e->getMessage(),
        'ESTADO'  => "0",
        'ID'      => "0"
    ];
}

echo json_encode($resultado, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
?>
