<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar el parámetro
if (!isset($datos[0]) || !filter_var($datos[0], FILTER_VALIDATE_INT)) {
    error_response("ID inválido o no proporcionado.");
}

$id = (int) $datos[0];

try {
    $sql = "SELECT * FROM consultar_movcaja_id(:id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (!$rows) {
        error_log("⚠️ No se encontró información para el ID: $id");
        $rows = [];
    }

    print_json($rows);
} catch (PDOException $e) {
    error_log("❌ Error en la consulta: " . $e->getMessage());
    error_response("Error al ejecutar la consulta: " . $e->getMessage());
} finally {
    $stmt = null;
    $conn = null;
}

// Funciones auxiliares
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
