<?php
error_reporting(E_ALL);
header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) !== 27) {
        throw new Exception("Número incorrecto de parámetros. Se esperaban 27.");
    }

    $sql = "SELECT im_movcaja(
        :ctiporecibo, :cnrecibo, :coperacion_id, :cfechaopera, :ccuenta_id, :cnombre,
        :cimporte, :cmoneda, :ctipocambio, :cdocfis, :cnserie, :cndocumento, :cfechaemi,
        :cpartida_id, :cnompartida, :cmov_id, :copera, :cbanco, :cctabancaria,
        :clugar, :cnoperabco, :cobservacion, :ccaja_sunat,
        :cempresa_id, :csucursal_id, :nidmovcaja, :cestado
    ) AS resultado";

    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':ctiporecibo',     $datos[0], PDO::PARAM_STR);
    $stmt->bindValue(':cnrecibo',        $datos[1], PDO::PARAM_STR);
    $stmt->bindValue(':coperacion_id',   $datos[2], PDO::PARAM_INT);
    $stmt->bindValue(':cfechaopera',     $datos[3], PDO::PARAM_STR);
    $stmt->bindValue(':ccuenta_id',      $datos[4], PDO::PARAM_INT);
    $stmt->bindValue(':cnombre',         $datos[5], PDO::PARAM_STR);
    $stmt->bindValue(':cimporte',        $datos[6]);
    $stmt->bindValue(':cmoneda',         $datos[7], PDO::PARAM_STR);
    $stmt->bindValue(':ctipocambio',     $datos[8]);
    $stmt->bindValue(':cdocfis',         $datos[9], PDO::PARAM_INT);
    $stmt->bindValue(':cnserie',         $datos[10], PDO::PARAM_STR);
    $stmt->bindValue(':cndocumento',     $datos[11], PDO::PARAM_STR);
    $stmt->bindValue(':cfechaemi',       $datos[12], PDO::PARAM_STR);
    $stmt->bindValue(':cpartida_id',     $datos[13], PDO::PARAM_INT);
    $stmt->bindValue(':cnompartida',     $datos[14], PDO::PARAM_STR);
    $stmt->bindValue(':cmov_id',         $datos[15], PDO::PARAM_INT);
    $stmt->bindValue(':copera',          $datos[16], PDO::PARAM_STR);
    $stmt->bindValue(':cbanco',          $datos[17], PDO::PARAM_STR);
    $stmt->bindValue(':cctabancaria',    $datos[18], PDO::PARAM_STR);
    $stmt->bindValue(':clugar',          $datos[19], PDO::PARAM_STR);
    $stmt->bindValue(':cnoperabco',      $datos[20], PDO::PARAM_STR);
    $stmt->bindValue(':cobservacion',    $datos[21], PDO::PARAM_STR);
    $stmt->bindValue(':ccaja_sunat',     filter_var($datos[22], FILTER_VALIDATE_BOOLEAN), PDO::PARAM_BOOL);
    $stmt->bindValue(':cempresa_id',     $datos[23], PDO::PARAM_INT);
    $stmt->bindValue(':csucursal_id',    $datos[24], PDO::PARAM_INT);
    $stmt->bindValue(':nidmovcaja',      $datos[25], PDO::PARAM_INT);
    $stmt->bindValue(':cestado',         $datos[26], PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($datos[26] === "NUEVO") {
        if ($result && isset($result['resultado']) && $result['resultado'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['resultado'],
                "MENSAJE" => "LA INFORMACIÓN SE GUARDÓ CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
            ];
        }
    } else {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => strval($datos[25]),
            "MENSAJE" => "LA INFORMACIÓN SE ACTUALIZÓ CORRECTAMENTE"
        ];
    }

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
