<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    if (!isset($datos[0], $datos[1], $datos[2], $datos[3], $datos[4])) {
        throw new Exception("Parmetros incompletos.");
    }

    $empresa_id      = (int)$datos[0];
    $sucursal_id     = (int)$datos[1];
    $cuenta_id       = (int)$datos[2];
    $fecha_operacion = $datos[3];              // 'YYYY-MM-DD'
    $anulado         = filter_var($datos[4], FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE);
    if ($anulado === null) { $anulado = false; }  // por si llega "0"/"1"/"" -> false

    $sql = "
    WITH dcset AS (
      SELECT dc.movimiento_id, dc.operacion
      FROM detcaja dc
      WHERE dc.empresa_id      = :empresa_id
        AND dc.sucursal_id     = :sucursal_id
        AND dc.cuenta_id       = :cuenta_id
        AND dc.fecha_operacion = :fecha_operacion
        AND dc.anulado         = :anulado
    ),
    base AS (
      SELECT COALESCE(SUM(dc.ingreso - dc.egreso), 0) AS saldo
      FROM detcaja dc
      WHERE dc.empresa_id      = :empresa_id
        AND dc.sucursal_id     = :sucursal_id
        AND dc.cuenta_id       = :cuenta_id
        AND dc.fecha_operacion = :fecha_operacion
        AND dc.anulado         = :anulado
    ),
    pe AS (
      SELECT COALESCE(SUM(dp.monto_pago), 0) AS total_pe
      FROM despacho_pago dp
      LEFT JOIN dcset mv_v
             ON mv_v.operacion = 'VTA' AND dp.venta_id    = mv_v.movimiento_id
      LEFT JOIN dcset mv_c
             ON mv_c.operacion = 'COB' AND dp.cobranza_id = mv_c.movimiento_id
      WHERE dp.activo = false
        AND (mv_v.movimiento_id IS NOT NULL OR mv_c.movimiento_id IS NOT NULL)
        AND UPPER(TRIM(dp.descripcion_pago)) <> 'EFECTIVO'
        AND dp.caja_id = :cuenta_id
        AND DATE(dp.fecha_registro) = :fecha_operacion
    )
    SELECT (b.saldo - p.total_pe) AS saldo_cierre
    FROM base b CROSS JOIN pe p
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id',      $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id',     $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':cuenta_id',       $cuenta_id, PDO::PARAM_INT);
    $stmt->bindParam(':fecha_operacion', $fecha_operacion, PDO::PARAM_STR);
    $stmt->bindParam(':anulado',         $anulado, PDO::PARAM_BOOL);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}