<?php
// clases/TokenValidator.php

class TokenValidator
{
    public static function validar($conn)
    {
        $headers = getallheaders();
        $authHeader = $headers['Authorization'] ?? '';

        if (!preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
            self::reject("Token faltante");
        }

        $token = $matches[1];

        // ✅ Validar existencia del token en la base de datos
        $stmt = $conn->prepare("SELECT usuario_id FROM tokens_sesion WHERE token = :token");
        $stmt->bindParam(':token', $token);
        $stmt->execute();

        if ($stmt->rowCount() === 0) {
            self::reject("Token inválido");
        }

        // ✅ Retornar ID de usuario para seguimiento
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        return $result['usuario_id'];
    }

    private static function reject($mensaje)
    {
        http_response_code(401);
        echo json_encode([
            "ESTADO" => "0",
            "ID" => 0,
            "MENSAJE" => $mensaje
        ], JSON_UNESCAPED_UNICODE);
        exit;
    }
}
