<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos['cliente_id'])) {
        throw new Exception("Falta el parámetro cliente_id.");
    }

    $cliente_id = (int)$datos['cliente_id'];

    $stmt = $conn->prepare("SELECT obtener_beneficios_cliente(:cliente_id)");
    $stmt->bindParam(':cliente_id', $cliente_id, PDO::PARAM_INT);
    $stmt->execute();

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    echo $resultado['obtener_beneficios_cliente'];

} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "Error: " . $e->getMessage()
    ]);
}
