<?php
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (
        !isset($datos['cliente_id']) ||
        !isset($datos['empresa_id']) ||
        !isset($datos['sucursal_id']) ||
        !isset($datos['detalle'])
    ) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $cliente_id = (int) $datos['cliente_id'];
    $empresa_id = (int) $datos['empresa_id'];
    $sucursal_id = (int) $datos['sucursal_id'];
    $detalle = json_encode($datos['detalle']);

    $stmt = $conn->prepare("SELECT im_descuento_cliente(:cliente_id, :empresa_id, :sucursal_id, :detalle)");
    $stmt->bindParam(':cliente_id', $cliente_id, PDO::PARAM_INT);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':detalle', $detalle, PDO::PARAM_STR);

    $stmt->execute();
    
    // ✅ Devuelve directamente el JSON generado por la función
    echo $stmt->fetchColumn();
    
} catch (Exception $e) {
    echo json_encode([
        'ESTADO' => '0',
        'MENSAJE' => 'Error: ' . $e->getMessage()
    ]);
}
