<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=UTF-8");

// Incluir conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

// Leer el JSON recibido
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// file_put_contents("debug.log", $bodyRequest . PHP_EOL, FILE_APPEND);

// Verificar si el JSON es válido
if (json_last_error() !== JSON_ERROR_NONE) {
    error_log("Error al decodificar JSON: " . json_last_error_msg());
    
    $respuesta = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "Error al decodificar el JSON: " . json_last_error_msg(),
        "RECIBIDO" => $bodyRequest
    ];
    
    header("HTTP/1.1 400 Bad Request");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);
    exit;
}

try {
    $conn->beginTransaction();

    // Preparar la llamada a la función im_cliente
    $sql = "SELECT im_cliente(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?) AS cliente_id";
    $stmt = $conn->prepare($sql);
    
    // Bind de los parámetros
    $stmt->bindParam(1,  $datos["cDocIdent"], PDO::PARAM_INT);
    $stmt->bindParam(2,  $datos["DocIdentidad"], PDO::PARAM_STR);
    $stmt->bindParam(3,  $datos["RazonSocial"], PDO::PARAM_STR);
    $stmt->bindParam(4,  $datos["Direccion"], PDO::PARAM_STR);
    $stmt->bindParam(5,  $datos["Ubigeo"], PDO::PARAM_STR);
    $stmt->bindParam(6,  $datos["Distrito"], PDO::PARAM_STR);
    $stmt->bindParam(7,  $datos["Provincia"], PDO::PARAM_STR);
    $stmt->bindParam(8,  $datos["Region"], PDO::PARAM_STR);
    $stmt->bindParam(9,  $datos["Contacto"], PDO::PARAM_STR);
    $stmt->bindParam(10, $datos["Email"], PDO::PARAM_STR);
    $stmt->bindParam(11, $datos["CtaBancaria1"], PDO::PARAM_STR);
    $stmt->bindParam(12, $datos["CtaBancaria2"], PDO::PARAM_STR);
    $stmt->bindParam(13, $datos["Telefono1"], PDO::PARAM_STR);
    $stmt->bindParam(14, $datos["Telefono2"], PDO::PARAM_STR);

    // Convertir Línea de Crédito a booleano (0 o 1)
    $linea_credito = filter_var($datos["LineaCredito"], FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE) ? 1 : 0;
    $stmt->bindParam(15, $linea_credito, PDO::PARAM_BOOL);

    $stmt->bindParam(16, $datos["ImpMaximo"], PDO::PARAM_STR);
    $stmt->bindParam(17, $datos["ImpConsumido"], PDO::PARAM_STR);
    $stmt->bindParam(18, $datos["NDias"], PDO::PARAM_INT);
    $stmt->bindParam(19, $datos["GiroNegocio"], PDO::PARAM_INT);
    $stmt->bindParam(20, $datos["Zona"], PDO::PARAM_INT);
    
    $imprime_precios = filter_var($datos["Imprime_Precios"], FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE) ? 1 : 0;
    $stmt->bindParam(21, $imprime_precios, PDO::PARAM_BOOL);
    
    $stmt->bindParam(22, $datos["ID_EMPRESA"], PDO::PARAM_INT);
    $stmt->bindParam(23, $datos["ID_SUCURSAL"], PDO::PARAM_INT);
    $stmt->bindParam(24, $datos["Id_Cliente"], PDO::PARAM_INT);
    $stmt->bindParam(25, $datos["Estado"], PDO::PARAM_STR);

    // Ejecutar la consulta
    $stmt->execute();

    $resultado = $stmt->fetch(PDO::FETCH_ASSOC);
    $cliente_id = $resultado['cliente_id'] ?? 0;
    
    if ($cliente_id > 0) {
        $conn->commit();
        $respuesta = [
            "ESTADO" => "1",
            "ID" => $cliente_id,
            "MENSAJE" => "Cliente procesado correctamente"
        ];
    } else {
        $conn->rollBack();
        $respuesta = [
            "ESTADO" => "0",
            "ID" => "0",
            "MENSAJE" => "ERROR AL PROCESAR EL CLIENTE"
        ];
    }

    echo json_encode($respuesta, JSON_PRETTY_PRINT);
} catch (PDOException $e) {
    $conn->rollBack();
    $respuesta = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ];
    header("HTTP/1.1 500 Internal Server Error");
    echo json_encode($respuesta, JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}
