<?php
//ob_start();
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=UTF-8");

ini_set('display_errors', 1);
error_reporting(E_ALL);

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $data = json_decode($bodyRequest, true);

    // Guardar el JSON recibido para depuración
    // file_put_contents("log_json_recibido.txt", $bodyRequest);

    if ($data === null) {
        throw new Exception("JSON inválido: " . json_last_error_msg());
    }

    if (!isset($data['Estado'])) {
        throw new Exception("Falta el campo 'Estado'.");
    }

    if (!isset($data['detalle']) || !is_array($data['detalle']) || !isset($data['pagos']) || !is_array($data['pagos'])) {
        throw new Exception("Los campos 'detalle' y 'pagos' deben ser arrays válidos.");
    }

    $conn->beginTransaction();

    $stmt = $conn->prepare("SELECT procesar_cobranza(
        :p_nrecibo, :p_fecha, :p_importe, :p_razon_social, :p_moneda, :p_tipo_cambio,
        :p_banco, :p_cuenta_corriente, :p_lugar, :p_operacion,
        :p_cliente_id, :p_empleado_id, :p_caja_id, :p_nombre_caja,
        :p_observacion, :p_sucursal_id, :p_empresa_id, :p_destino_cobranza,
        :p_id_cobranza, :p_estado, :p_detalle, :p_pagos
    ) AS id_cobranza");

    $stmt->execute([
        ':p_nrecibo'           => $data['NRecibo'],
        ':p_fecha'             => $data['Fecha'],
        ':p_importe'           => $data['Deuda'],
        ':p_razon_social'      => $data['Nombre'],
        ':p_moneda'            => $data['Moneda'],
        ':p_tipo_cambio'       => $data['Tipo_Cambio'],
        ':p_banco'             => $data['Banco'],
        ':p_cuenta_corriente'  => $data['CtaBco'],
        ':p_lugar'             => $data['Lugar_Pago'],
        ':p_operacion'         => $data['NOperacion'],
        ':p_cliente_id'        => $data['Cliente_Id'],
        ':p_empleado_id'       => $data['Empleado_Id'],
        ':p_caja_id'           => $data['Caja_Id'],
        ':p_nombre_caja'       => $data['NomCaja'],
        ':p_observacion'       => $data['Observacion'],
        ':p_sucursal_id'       => $data['Sucursal_Id'],
        ':p_empresa_id'        => $data['Empresa_Id'],
        ':p_destino_cobranza'  => $data['Destino_Cobranza'],
        ':p_id_cobranza'       => $data['nIdCob_Mod'] ?? 0,
        ':p_estado'            => $data['Estado'],
        ':p_detalle'           => json_encode($data['detalle'], JSON_UNESCAPED_UNICODE),
        ':p_pagos'             => json_encode($data['pagos'], JSON_UNESCAPED_UNICODE)
    ]);

    $idCobranza = $stmt->fetchColumn();
    $conn->commit();

    // 🔹 Registrar en log
    // file_put_contents("log_respuesta.txt", "ID generado: " . ($idCobranza ?? 'NULL') . "\n", FILE_APPEND);

    // 🔹 Limpiar salida y devolver JSON
    // ob_clean();
    echo json_encode([
        "ESTADO"  => $idCobranza > 0 ? "1" : "0",
        "ID"      => $idCobranza ?: 0,
        "MENSAJE" => $idCobranza > 0 ? "COBRANZA PROCESADA" : "NO SE GENERÓ ID"
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

} catch (Exception $e) {
    if ($conn && $conn->inTransaction()) $conn->rollBack();

    ob_clean();
    echo json_encode([
        "ESTADO" => "0",
        "ID" => 0,
        "MENSAJE" => "❌ ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}