<?php
header('Content-Type: application/json');
include_once '../conexion.php';

try {
    $input = json_decode(file_get_contents("php://input"), true);
    $producto_id = $input[0] ?? null;
    $almacen_id = $input[1] ?? null;

    if (!$producto_id || !$almacen_id) {
        throw new Exception("Faltan parámetros.");
    }

    // Consulta directa a la tabla productoalmacen
    $stmt = $conn->prepare("
        SELECT 
            stock_actual AS stock,
            costo
        FROM productoalmacen
        WHERE producto_id = :producto_id
          AND almacen_id = :almacen_id
        LIMIT 1
    ");
    $stmt->execute([
        ':producto_id' => $producto_id,
        ':almacen_id' => $almacen_id
    ]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($data) {
        echo json_encode([
            'stock' => (float)$data['stock'],
            'costo' => (float)$data['costo']
        ]);
    } else {
        echo json_encode([
            'stock' => 0.00,
            'costo' => 0.00
        ]);
    }

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => true,
        'mensaje' => $e->getMessage()
    ]);
}
