<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php'; 
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    error_response("JSON inválido: " . json_last_error_msg());
}

try {
    $sql = "SELECT * FROM verifica_pagosxdoc(?, ?, ?)";
    $stmt = $conn->prepare($sql);

    $stmt->bindParam(1, $datos[0], PDO::PARAM_INT); // documento_id
    $stmt->bindParam(2, $datos[1], PDO::PARAM_INT); // empresa_id
    $stmt->bindParam(3, $datos[2], PDO::PARAM_INT); // sucursal_id

    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    print_json($rows);
} catch (PDOException $e) {
    error_response("Error en la ejecución: " . $e->getMessage());
} finally {
    $conn = null;
}

// Función para imprimir respuesta JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH: error_response('Maximum stack depth exceeded'); break;
        case JSON_ERROR_STATE_MISMATCH: error_response('Underflow or mismatch'); break;
        case JSON_ERROR_CTRL_CHAR: error_response('Unexpected control character'); break;
        case JSON_ERROR_SYNTAX: error_response('Syntax error in JSON'); break;
        case JSON_ERROR_UTF8: error_response('Malformed UTF-8 characters'); break;
        default: error_response('Unknown error in JSON'); break;
    }
}

// Función para respuesta de error
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}