<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!is_array($datos) || count($datos) < 8) {
        throw new Exception("Parámetros incompletos. Se requieren 8 valores.");
    }

    // Asignación de variables
    $ctipdoc         = $datos[0];
    $cdocidentidad   = $datos[1];
    $cnombre         = $datos[2];
    $capellidos      = $datos[3];
    $clicencia       = $datos[4];
    $cempresa_id     = $datos[5];
    $nidcond         = $datos[6];
    $cestado         = $datos[7];

    // Llamada a la función de PostgreSQL
    $sql = "SELECT * FROM im_conductor(:ctipdoc, :cdocidentidad, :cnombre, :capellidos, :clicencia, :cempresa_id, :nidcond, :cestado)";
    $stmt = $conn->prepare($sql);

    $stmt->bindValue(':ctipdoc',       $ctipdoc, PDO::PARAM_INT);
    $stmt->bindValue(':cdocidentidad', $cdocidentidad, PDO::PARAM_STR);
    $stmt->bindValue(':cnombre',       $cnombre, PDO::PARAM_STR);
    $stmt->bindValue(':capellidos',    $capellidos, PDO::PARAM_STR);
    $stmt->bindValue(':clicencia',     $clicencia, PDO::PARAM_STR);
    $stmt->bindValue(':cempresa_id',   $cempresa_id, PDO::PARAM_INT);
    $stmt->bindValue(':nidcond',       $nidcond, PDO::PARAM_INT);
    $stmt->bindValue(':cestado',       $cestado, PDO::PARAM_STR);

    $stmt->execute();
    $result = $stmt->fetch(PDO::FETCH_ASSOC);

    $respuesta = [];

    if ($cestado === "NUEVO") {
        if ($result && isset($result['id_cond']) && $result['id_cond'] > 0) {
            $respuesta = [
                "ESTADO" => "1",
                "ID" => $result['id_cond'],
                "MENSAJE" => "LA INFORMACION GUARDO CORRECTAMENTE"
            ];
        } else {
            $respuesta = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACION"
            ];
        }
    } else {
        $respuesta = [
            "ESTADO" => "1",
            "ID" => strval($nidcond),
            "MENSAJE" => "LA INFORMACION ACTUALIZO CORRECTAMENTE"
        ];
    }    

    echo json_encode($respuesta, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
?>
