<?php
    // Permitir solicitudes desde cualquier origen (CORS)
    header("Access-Control-Allow-Origin: *");
    header("Access-Control-Allow-Headers: Content-Type");
    header("Access-Control-Allow-Methods: POST");
    header("Content-Type: application/json; charset=UTF-8");
    
    if ($_SERVER['REQUEST_METHOD'] === 'POST') {
      $nombre  = isset($_POST['nombre'])  ? trim($_POST['nombre'])  : '';
      $email   = isset($_POST['email'])   ? trim($_POST['email'])   : '';
      $mensaje = isset($_POST['mensaje']) ? trim($_POST['mensaje']) : '';
    
      // Validar campos
      if (empty($nombre) || empty($email) || empty($mensaje)) {
        http_response_code(400);
        echo json_encode(["error" => "Faltan campos obligatorios"]);
        exit;
      }
    
      // Datos del correo
      $para = "sicse.mkj@gmail.com";
      $asunto = "Mensaje desde el sitio web SICSE";
      $cuerpo = "Nombre: $nombre\nEmail: $email\n\nMensaje:\n$mensaje";
      $cabeceras = "From: $email\r\nReply-To: $email\r\n";
    
      // Enviar correo
      if (mail($para, $asunto, $cuerpo, $cabeceras)) {
        http_response_code(200);
        echo json_encode(["mensaje" => "Correo enviado correctamente"]);
      } else {
        http_response_code(500);
        echo json_encode(["error" => "No se pudo enviar el correo"]);
      }
    } else {
      http_response_code(405);
      echo json_encode(["error" => "Método no permitido"]);
    }
?>