<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php'; 

try {
    $body = file_get_contents("php://input");
    $datos = json_decode($body, true);

    if (!isset($datos[0])) {
        throw new Exception("Falta parámetro de filtro.");
    }

    $filtro = $datos[0]; 

    // Ejecutar para ventas
    $sqlVentas = "SELECT * FROM informe_estadistico('1', :filtro)";
    $stmtV = $conn->prepare($sqlVentas);
    $stmtV->bindParam(':filtro', $filtro, PDO::PARAM_STR);
    $stmtV->execute();
    $ventas = $stmtV->fetchAll(PDO::FETCH_ASSOC);

    // Ejecutar para compras
    $sqlCompras = "SELECT * FROM informe_estadistico('3', :filtro)";
    $stmtC = $conn->prepare($sqlCompras);
    $stmtC->bindParam(':filtro', $filtro, PDO::PARAM_STR);
    $stmtC->execute();
    $compras = $stmtC->fetchAll(PDO::FETCH_ASSOC);

    // Armar respuesta combinada por mes
    $respuesta = [];

    foreach ($ventas as $v) {
        $mes = $v['mes'];
        $respuesta[$mes] = [
            'nommesabrev' => $v['nommesabrev'],
            'ventas' => (float)$v['total'],
            'compras' => 0
        ];
    }

    foreach ($compras as $c) {
        $mes = $c['mes'];
        if (!isset($respuesta[$mes])) {
            $respuesta[$mes] = [
                'nommesabrev' => $c['nommesabrev'],
                'ventas' => 0,
                'compras' => (float)$c['total']
            ];
        } else {
            $respuesta[$mes]['compras'] = (float)$c['total'];
        }
    }

    // Reordenar por mes
    ksort($respuesta);

    echo json_encode(array_values($respuesta), JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        "error" => "Error en el servidor: " . $e->getMessage()
    ]);
}
