<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$data = json_decode(file_get_contents('php://input'), true);
$turno_id = $data[0];
$fecha_cierre = $data[1];
$empresa_id = $data[2];
$sucursal_id = $data[3];
$empleado_id = $data[4];


try {
    $sql = "SELECT cerrar_turno(:turno_id, :fecha_cierre, :empresa_id, :sucursal_id, :empleado_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':turno_id' => $turno_id,
        ':fecha_cierre' => $fecha_cierre,
        ':empresa_id' => $empresa_id,
        ':sucursal_id' => $sucursal_id,
        ':empleado_id' => $empleado_id
    ]);

    echo json_encode(["ESTADO" => "1", "MENSAJE" => "Turno cerrado correctamente."]);
} catch (PDOException $e) {
    echo json_encode(["ESTADO" => "0", "MENSAJE" => "Error: " . $e->getMessage()]);
}