<?php
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Validar que se reciban los datos esperados
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input[0], $input[1], $input[2], $input[3])) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $pempresa_id = (int) $input[0];
    $psucursal_id = (int) $input[1];
    $pturno_id = (int) $input[2];
    $pestado = (string) $input[3];

    // Preparar y ejecutar la función PostgreSQL
    $stmt = $conn->prepare("SELECT contar_despachos_sin_venta(:empresa_id, :sucursal_id, :turno_id, :estado) AS total");
    $stmt->bindParam(':empresa_id', $pempresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $psucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':turno_id', $psurtidor_turno_id, PDO::PARAM_INT);
    $stmt->bindParam(':estado', $pestado, PDO::PARAM_STR);
    $stmt->execute();

    $row = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($row && isset($row['total'])) {
        echo json_encode([
            'ESTADO' => 'OK',
            'TOTAL' => (int) $row['total']
        ]);
    } else {
        echo json_encode([
            'ESTADO' => 'ERROR',
            'MENSAJE' => 'No se obtuvo un resultado válido de la función.'
        ]);
    }

} catch (Exception $e) {
    echo json_encode([
        'ESTADO' => 'ERROR',
        'MENSAJE' => $e->getMessage()
    ]);
}
?>
