<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar parámetros
    if (!isset($datos[0])) {
        throw new Exception("Parámetro inválido: Se requiere turno_id.");
    }

    $sql = "SELECT * FROM despachos_a_boletear(:turno_id)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':turno_id', $datos[0], PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_json($rows);

} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
} finally {
    unset($stmt);
    $conn = null;
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
