<?php
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents('php://input'), true);
    $cliente_id = $input['cliente_id'] ?? 0;

    if ($cliente_id <= 0) {
        throw new Exception("ID de cliente inválido");
    }

    $stmt = $conn->prepare("SELECT id, placa, cliente_id FROM placa_cliente WHERE cliente_id = :cliente_id");
    $stmt->execute([':cliente_id' => $cliente_id]);
    $placas = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "ESTADO" => "OK",
        "DATA" => $placas
    ]);

} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "ERROR",
        "MENSAJE" => $e->getMessage()
    ]);
}
