<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validación de parámetros
    if (
        !isset($datos[0], $datos[1], $datos[2], $datos[3]) ||
        !is_numeric($datos[0]) || !is_numeric($datos[1]) || !is_numeric($datos[2])
    ) {
        throw new Exception("Parámetros inválidos: Se requieren empresa_id, sucursal_id, empleado_id (numéricos) y filtro.");
    }

    $empresa_id = (int) $datos[0];
    $sucursal_id = (int) $datos[1];
    $empleado_id = (int) $datos[2];
    $filtro = trim($datos[3]);

    $sql = "SELECT * FROM controlador.listar_despachos_turno_abierto(:empresa_id, :sucursal_id, :empleado_id, :filtro)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindValue(':empleado_id', $empleado_id, PDO::PARAM_INT);
    $stmt->bindValue(':filtro', $filtro, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_json($rows);

} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
} finally {
    unset($stmt);
    $conn = null;
}

// Función para responder en JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

// Función para error
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
