<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permitir solicitudes desde frontend
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);
$rows = array();

try {
    // Validación mínima
    if (!isset($datos[0]) || !isset($datos[1])) {
        throw new Exception("Parámetros incompletos. Se requiere turno_id y empresa_id.");
    }

    /*$sql = "
    SELECT -1 AS id, 'TODOS' AS nombre_completo
    UNION ALL
    SELECT u.id, u.nombre_completo
    FROM usuarios u
    INNER JOIN turno_detalle td ON td.usuario_id = u.id
    INNER JOIN turno_apertura ta ON ta.id = td.turno_apertura_id
    WHERE ta.id = :turno_id AND u.empresa_id = :empresa_id
    GROUP BY u.id, u.nombre_completo
    ORDER BY nombre_completo;
    ";*/

    $sql = "
    SELECT DISTINCT u.id, u.nombre_completo
    FROM usuarios u
    INNER JOIN turno_detalle td ON td.usuario_id = u.id
    WHERE td.turno_apertura_id = :turno_id
    AND u.empresa_id = :empresa_id
    ORDER BY u.nombre_completo;
    ";

    $stmt = $conn->prepare($sql);

    // Enlazar los parámetros correctamente
    $stmt->bindValue(':turno_id', (int)$datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':empresa_id', (int)$datos[1], PDO::PARAM_INT);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    if (empty($rows)) {
        $rows = [];
    }

} catch (Exception $e) {
    error_response("Error al ejecutar la consulta: " . $e->getMessage());
}

$conn = null;
print_json($rows);

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error de codificación JSON: " . json_last_error_msg());
    }
}

function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
