<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    // Validar parámetros: turno_id, empleado_id, filtro
    
    if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
        throw new Exception("Parámetros incompletos. Se requieren: turno_id, empleado_id, filtro, tipo_doc.");
    }

    $turno_id = (int) $datos[0];
    $empleado_id = (int) $datos[1]; // puede ser 0 para turno completo
    $filtro = trim($datos[2]);
    $tipo_doc = (string) $datos[3];

    $sql = "SELECT * FROM controlador.listar_despachos_turno_general(:turno_id, :empleado_id, :filtro, :tipo_doc)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':turno_id', $turno_id, PDO::PARAM_INT);
    $stmt->bindValue(':empleado_id', $empleado_id, PDO::PARAM_INT);
    $stmt->bindValue(':filtro', $filtro, PDO::PARAM_STR);
    $stmt->bindValue(':tipo_doc', $tipo_doc, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    print_json($rows);

} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
} finally {
    unset($stmt);
    $conn = null;
}

// Función para respuesta correcta
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        error_response("Error al generar JSON: " . json_last_error_msg());
    }
}

// Función para respuesta de error
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
