<?php
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

header("Content-Type: application/json; charset=utf-8");

try {
    $data = json_decode(file_get_contents("php://input"), true);
    if (!isset($data[0])) throw new Exception("ID de despacho no enviado");

    $sql = "UPDATE controlador.\"DESPACHOS\" SET reservado = true WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':id', $data[0], PDO::PARAM_INT);
    $stmt->execute();

    echo json_encode(["estado" => "1", "mensaje" => "Reservado correctamente"]);
} catch (Exception $e) {
    echo json_encode(["estado" => "0", "mensaje" => $e->getMessage()]);
}
