<?php
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);
$json = json_decode(file_get_contents("php://input"), true);

if (!isset($json['detalle'])) {
    echo json_encode(['estado' => '0', 'mensaje' => "Sin datos."]);
    exit;
}

$stmt = $conn->prepare("SELECT im_telemetria_tanque(
    :probe, :fecha_hora, :nivel, :volumen, :volumen_tc, :temperatura,
    :agua, :densidad, :porcentaje, :empresa_id, :sucursal_id, :producto_id, :turno_id)");

foreach ($json['detalle'] as $fila) {
    $stmt->execute([
        ':probe' => $fila['probe'],
        ':fecha_hora' => $fila['fecha_hora'],
        ':nivel' => $fila['nivel'],
        ':volumen' => $fila['volumen'],
        ':volumen_tc' => $fila['volumen_tc'],
        ':temperatura' => $fila['temperatura'],
        ':agua' => $fila['agua'],
        ':densidad' => $fila['densidad'],
        ':porcentaje' => $fila['porcentaje'],
        ':empresa_id' => $fila['empresa_id'],
        ':sucursal_id' => $fila['sucursal_id'],
        ':producto_id' => $fila['producto_id'],
        ':turno_id' => $fila['turno_id']
    ]);
}

echo json_encode(['estado' => '1', 'mensaje' => 'Telemetría registrada.'], JSON_UNESCAPED_UNICODE);
