<?php
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer datos recibidos
    $datos = json_decode(file_get_contents("php://input"), true);

    if (!isset($datos[0], $datos[1], $datos[2])) {
        throw new Exception("Parámetros incompletos. Se requieren: turno_id, empleado_id, caja_id.");
    }

    $turno_id = (int) $datos[0];
    $empleado_id = (int) $datos[1];
    $caja_id = (int) $datos[2];

    $sql = "SELECT * FROM wincha_despachos_general(:turno_id, :empleado_id, :caja_id)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':turno_id' => $turno_id,
        ':empleado_id' => $empleado_id,
        ':caja_id' => $caja_id
    ]);

    $resultados = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        "ESTADO" => "1",
        "MENSAJE" => "Consulta exitosa",
        "data" => $resultados
    ]);
} catch (Exception $e) {
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => $e->getMessage()
    ]);
}
?>
