<?php
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);
$input = json_decode(file_get_contents("php://input"), true);

$id = $input['id'];
$asistio = $input['asistio'] ? 'true' : 'false';
$observacion = $input['observacion'] ?? '';

try {
    $sql = "UPDATE asistencias SET asistio = :asistio, observacion = :observacion WHERE id = :id";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':asistio', $asistio, PDO::PARAM_BOOL);
    $stmt->bindParam(':observacion', $observacion, PDO::PARAM_STR);
    $stmt->bindParam(':id', $id, PDO::PARAM_INT);
    $stmt->execute();

    echo json_encode(["estado" => "1", "mensaje" => "Actualización exitosa"]);
} catch (Exception $e) {
    echo json_encode(["estado" => "0", "mensaje" => $e->getMessage()]);
}
