<?php
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);
$input = json_decode(file_get_contents("php://input"), true);

$empresa_id = $input['empresa_id'];
$sucursal_id = $input['sucursal_id'];
$fecha = $input['fecha'];

try {
    $sql = "SELECT * FROM listar_asistencias_registradas(:empresa, :sucursal, :fecha)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa', $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':fecha', $fecha, PDO::PARAM_STR);
    $stmt->execute();
    $resultado = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($resultado);
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
}
