<?php
header('Content-Type: application/json');

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents("php://input"), true);

    $empresa_id = $input["empresa_id"] ?? null;
    $sucursal_id = $input["sucursal_id"] ?? null;
    $fecha_inicio = $input["fecha_inicio"] ?? null;
    $fecha_final = $input["fecha_final"] ?? null;
    $forma_pago = isset($input["forma_pago"]) ? (int)$input["forma_pago"] : null;

    if (!$empresa_id || !$sucursal_id || !$fecha_inicio || !$fecha_final || !$forma_pago) {
        throw new Exception("Faltan parámetros obligatorios.");
    }

    $query = "
        SELECT *
        FROM planilla_empleados(:empresa_id, :sucursal_id, :fecha_inicio, :fecha_final, :forma_pago)
    ";

    $stmt = $conn->prepare($query);
    $stmt->execute([
        ':empresa_id' => $empresa_id,
        ':sucursal_id' => $sucursal_id,
        ':fecha_inicio' => $fecha_inicio,
        ':fecha_final' => $fecha_final,
        ':forma_pago' => $forma_pago
    ]);

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $response = [];
    foreach ($rows as $row) {
        $emp_id = $row["empleado_id"];

        if (!isset($response[$emp_id])) {
            $response[$emp_id] = [
                "empleado_id" => $emp_id,
                "nombre" => $row["nombre"],
                "documento" => $row["documento"],
                "asistencias" => [],
                "sueldo" => "NO REGISTRADO",
                "adelantos" => 0,
                "pagar" => "NO CALCULADO",
                "modos" => [],
                "forma_pago" => $row["forma_pago"]
            ];
        }

        if ($row["fecha"] !== null) {
            $fecha = date('Y-m-d', strtotime($row["fecha"]));
            $response[$emp_id]["asistencias"][$fecha] = is_null($row["asistio"]) ? null : (bool)$row["asistio"];
            $response[$emp_id]["modos"][$fecha] = $row["modo"] ?? "FALTA";
        }

        if (!is_null($row["sueldo"])) {
            $response[$emp_id]["sueldo"] = round($row["sueldo"], 2);
        }
        if (!is_null($row["adelantos"])) {
            $response[$emp_id]["adelantos"] = round($row["adelantos"], 2);
        }
        if (!is_null($row["pagar"])) {
            $response[$emp_id]["pagar"] = round($row["pagar"], 2);
        }
    }

    echo json_encode(array_values($response), JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    echo json_encode(["error" => $e->getMessage()]);
}