<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json; charset=UTF-8");
header("Access-Control-Allow-Methods: POST");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Validar token
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer parámetros (opcionalmente permitir pasar la fecha)
    $input = json_decode(file_get_contents("php://input"), true);
    $fecha = isset($input['fecha']) ? $input['fecha'] : date('Y-m-d');

    $sql = "SELECT registrar_asistencias_diarias(:fecha)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':fecha', $fecha, PDO::PARAM_STR);
    $stmt->execute();

    echo json_encode(["ESTADO" => 1, "MENSAJE" => "Asistencias insertadas para $fecha."]);
} catch (Exception $e) {
    echo json_encode(["ESTADO" => 0, "MENSAJE" => "Error: " . $e->getMessage()]);
}
?>
