<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permitir solicitudes desde cualquier origen
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

// Incluir conexión a la base de datos
include_once '../conexion.php';

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$response = [];

try {
    // Configurar modo de errores
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Preparar la consulta para ejecutar el procedimiento almacenado
    $sql = "SELECT * FROM Listar_Empresas(?)";
    $stmt = $conn->prepare($sql);

    // Vincular parámetro
    $stmt->bindValue(1, $datos[0], PDO::PARAM_STR);

    // Ejecutar la consulta
    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stmt->closeCursor(); // Liberar el resultado

    // Verificar si hay resultados
    if (!empty($rows)) {
        $response = $rows;
    }

} catch (PDOException $e) {
    error_response("ERROR: " . $e->getMessage());
}

// Cerrar conexión
$conn = null;

// Imprimir la respuesta en JSON
print_json($response);

// Función para imprimir JSON
function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
}

// Función para manejar errores
function error_response($message) {
    http_response_code(500);
    echo json_encode(['error' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>
