<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

try {
    // Preparar la llamada a la función en PostgreSQL
    $sql = "SELECT * FROM Actualiza_Costo_Inv(:param1, :param2)"; // Asume que Actualiza_Costo_Inv es una función en PostgreSQL
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':param1', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':param2', $datos[1], PDO::PARAM_STR);
    $stmt->execute();

    // Obtener el resultado de la función
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    $nRegistros = $result['actualiza_costo_inv']; // Asume que la función devuelve el número de registros afectados

    if ($nRegistros > 0) {
        $resultado = array();
        $resultado['ESTADO'] = "1";
        $resultado['REGISTROS'] = $nRegistros;
        $resultado['MENSAJE'] = "LA INFORMACION SE ACTUALIZO CORRECTAMENTE";
        //http_response_code(200);
    } else {
        $resultado = array();
        $resultado['ESTADO'] = "0";
        $resultado['REGISTROS'] = "0";
        $resultado['MENSAJE'] = "ERROR AL ACTUALIZAR LA INFORMACIÓN";
        //http_response_code(500);
    }
} catch (PDOException $e) {
    $resultado = array();
    $resultado['MENSAJE'] = "ERROR: " . $e->getMessage();
    $resultado['ESTADO'] = "0";
    $resultado['ID'] = "0";
    //http_response_code(500);
}

$conn = null; // Cerrar la conexión a PostgreSQL

header("Content-Type: application/json; charset=UTF-8");
echo json_encode($resultado, JSON_PRETTY_PRINT);
?>