<?php
// error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json; charset=utf-8");

// Incluir conexión a la base de datos
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $input = json_decode(file_get_contents('php://input'), true);

    if (!isset($input[0], $input[1], $input[2], $input[3], $input[4])) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $empresa_id    = $input[0];
    $sucursal_id   = $input[1];
    $fecha_inicio  = $input[2]; // formato YYYY-MM-DD
    $fecha_fin     = $input[3]; // formato YYYY-MM-DD
    $filtro        = $input[4];

    // Validar filtro vacío como comodín
    if (trim($filtro) === "") {
        $filtro = "%";
    }

    $sql = "SELECT * FROM listar_apertura_turnos(:empresa_id, :sucursal_id, :fecha_inicio, :fecha_fin, :filtro)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':fecha_inicio', $fecha_inicio);
    $stmt->bindParam(':fecha_fin', $fecha_fin);
    $stmt->bindParam(':filtro', $filtro, PDO::PARAM_STR);
    $stmt->execute();

    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($result);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(["estado" => "error", "mensaje" => $e->getMessage()]);
}
?>
