<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';

    $empresa_id = $_GET['empresa_id'] ?? null;
    $sucursal_id = $_GET['sucursal_id'] ?? null;

    if (!$empresa_id || !$sucursal_id) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $stmt = $conn->prepare("SELECT * FROM listar_jerarquia_grifos(:empresa_id, :sucursal_id)");
    $stmt->execute([
        ':empresa_id' => $empresa_id,
        ':sucursal_id' => $sucursal_id
    ]);

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'estado' => 'OK',
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
