<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';
    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) throw new Exception("JSON inválido.");

    $stmt = $conn->prepare("SELECT * FROM im_medicion_manguera(
        :pid, :psurtidor_turno_id, :pmanguera_id, :plectura_inicial, :plectura_final
    )");

    $stmt->execute([
        ':pid' => $input['id'] ?? 0,
        ':psurtidor_turno_id' => $input['surtidor_turno_id'],
        ':pmanguera_id' => $input['manguera_id'],
        ':plectura_inicial' => $input['lectura_inicial'],
        ':plectura_final' => $input['lectura_final']
    ]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'estado' => $data['estado'],
        'id' => $data['id'],
        'mensaje' => $data['mensaje']
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
