<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) throw new Exception("JSON inválido.");

    $stmt = $conn->prepare("SELECT * FROM im_movimiento_caja(
        :pid, :ptipo_movimiento, :pconcepto, :pdetalle,
        :pmonto, :pmedio_pago, :pcuenta_origen, :preferencia_documento,
        :pusuario_id, :pempresa_id, :psucursal_id
    )");

    $stmt->execute([
        ':pid' => $input['id'] ?? 0,
        ':ptipo_movimiento' => $input['tipo_movimiento'],
        ':pconcepto' => $input['concepto'],
        ':pdetalle' => $input['detalle'],
        ':pmonto' => $input['monto'],
        ':pmedio_pago' => $input['medio_pago'],
        ':pcuenta_origen' => $input['cuenta_origen'],
        ':preferencia_documento' => $input['referencia_documento'],
        ':pusuario_id' => $input['usuario_id'],
        ':pempresa_id' => $input['empresa_id'],
        ':psucursal_id' => $input['sucursal_id']
    ]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'estado' => $data['estado'],
        'id' => $data['id'],
        'mensaje' => $data['mensaje']
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
