<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$body = file_get_contents("php://input");
$data = json_decode($body, true);

try {
    $sql = "SELECT * FROM im_turno_apertura(
        :p_turno_id,
        :p_fecha_inicio,
        :p_fecha_cierre,
        :p_estado,
        :p_surtidores_habilitados,
        :p_mangueras_habilitadas,
        :p_usuario_apertura_id,
        :p_empresa_id,
        :p_sucursal_id,
        :p_id,
        :p_estado_registro,
        :p_detalles
    );";

    $stmt = $conn->prepare($sql);

    // Parámetros desde el objeto JSON recibido
    $stmt->bindValue(':p_turno_id', $data['turno_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_fecha_inicio', $data['fecha_inicio'], PDO::PARAM_STR);
    $stmt->bindValue(':p_fecha_cierre', $data['fecha_cierre'], PDO::PARAM_STR);
    $stmt->bindValue(':p_estado', $data['estado'], PDO::PARAM_STR); // 'ABIERTO' o 'CERRADO'
    $stmt->bindValue(':p_surtidores_habilitados', $data['surtidores_habilitados'], PDO::PARAM_INT);
    $stmt->bindValue(':p_mangueras_habilitadas', $data['mangueras_habilitadas'], PDO::PARAM_INT);
    $stmt->bindValue(':p_usuario_apertura_id', $data['usuario_apertura_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_empresa_id', $data['empresa_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_sucursal_id', $data['sucursal_id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_id', $data['id'], PDO::PARAM_INT);
    $stmt->bindValue(':p_estado_registro', $data['estado_registro'], PDO::PARAM_STR); // NUEVO o MODIFICAR

    // Convertir array detalle a JSON
    $jsonDetalle = isset($data['detalles']) ? json_encode($data['detalles']) : null;
    $stmt->bindValue(':p_detalles', $jsonDetalle, PDO::PARAM_STR);

    $stmt->execute();
    $id = $stmt->fetchColumn();

    if ($id > 0) {
        echo json_encode([
            "ESTADO" => "1",
            "MENSAJE" => "Turno apertura registrado correctamente",
            "id_turno_apertura" => $id
        ]);
    } else {
        echo json_encode([
            "ESTADO" => "0",
            "MENSAJE" => "No se pudo registrar el turno apertura"
        ]);
    }

} catch (PDOException $e) {
    echo json_encode([
        "ESTADO" => "0",
        "MENSAJE" => "Error: " . $e->getMessage()
    ]);
}

$conn = null;
?>