<?php
header('Content-Type: application/json');
try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) throw new Exception("JSON inválido.");

    $stmt = $conn->prepare("SELECT * FROM im_cuenta_cobrar_vale(
        :pid, :pcliente_id, :pvale_id, :pmonto_total,
        :pmonto_pagado, :pobservacion, :pempresa_id, :psucursal_id
    )");

    $stmt->execute([
        ':pid' => $input['id'] ?? 0,
        ':pcliente_id' => $input['cliente_id'],
        ':pvale_id' => $input['vale_id'],
        ':pmonto_total' => $input['monto_total'],
        ':pmonto_pagado' => $input['monto_pagado'],
        ':pobservacion' => $input['observacion'],
        ':pempresa_id' => $input['empresa_id'],
        ':psucursal_id' => $input['sucursal_id']
    ]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'estado' => $data['estado'],
        'id' => $data['id'],
        'mensaje' => $data['mensaje']
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
