<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $input = json_decode(file_get_contents('php://input'), true);
    if (!$input) throw new Exception("JSON inválido.");

    $stmt = $conn->prepare("SELECT * FROM im_despacho_combustible(
        :pid, :psurtidor_turno_id, :pmanguera_id, :phora_despacho,
        :pvolumen_galones, :pimporte_soles, :ptipo_pago,
        :pobservacion, :pcliente_id, :pnumero_vale,
        :pempresa_id, :psucursal_id
    )");

    $stmt->execute([
        ':pid' => $input['id'] ?? 0,
        ':psurtidor_turno_id' => $input['surtidor_turno_id'],
        ':pmanguera_id' => $input['manguera_id'],
        ':phora_despacho' => $input['hora_despacho'],
        ':pvolumen_galones' => $input['volumen_galones'],
        ':pimporte_soles' => $input['importe_soles'],
        ':ptipo_pago' => $input['tipo_pago'],
        ':pobservacion' => $input['observacion'],
        ':pcliente_id' => $input['cliente_id'],
        ':pnumero_vale' => $input['numero_vale'],
        ':pempresa_id' => $input['empresa_id'],
        ':psucursal_id' => $input['sucursal_id']
    ]);

    $data = $stmt->fetch(PDO::FETCH_ASSOC);
    echo json_encode([
        'estado' => $data['estado'],
        'id' => $data['id'],
        'mensaje' => $data['mensaje']
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
