<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión a PostgreSQL
include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $data = json_decode(file_get_contents("php://input"), true);

    if (!isset($data[0], $data[1], $data[2], $data[3])) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $empresa_id   = (int) $data[0];
    $sucursal_id  = (int) $data[1];
    $fecha_inicio = $data[2];
    $turno_id     = (int) $data[3];

    $sql = "
        SELECT 'Ya existe un turno asignado con los mismos datos' AS mensaje
        FROM turno_apertura
        WHERE empresa_id = :empresa_id
          AND sucursal_id = :sucursal_id
          AND turno_id = :turno_id
          AND DATE(fecha_inicio) = :fecha_inicio::date
        LIMIT 1
    ";

    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':empresa_id', $empresa_id, PDO::PARAM_INT);
    $stmt->bindParam(':sucursal_id', $sucursal_id, PDO::PARAM_INT);
    $stmt->bindParam(':fecha_inicio', $fecha_inicio, PDO::PARAM_STR);
    $stmt->bindParam(':turno_id', $turno_id, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows ?: [], JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()]);
} finally {
    $conn = null;
}
