<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: POST, PUT, GET, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (json_last_error() !== JSON_ERROR_NONE) {
    $resultado = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "JSON inválido: " . json_last_error_msg()
    ];
    http_response_code(400);
    echo json_encode($resultado, JSON_PRETTY_PRINT);
    exit;
}

try {
    $conn->beginTransaction();

    $sql = "SELECT im_remitente(?, ?, ?, ?, ?, ?, ?, ?) AS remitente_id";
    $stmt = $conn->prepare($sql);

    // Extraer valores desde el JSON
    $ctipodoc     = $datos["cDocIdent"] ?? 0;
    $cdocidentidad= $datos["DocIdentidad"] ?? '';
    $cnombre      = $datos["RazonSocial"] ?? '';
    $cdireccion   = $datos["Direccion"] ?? '';
    $ctipo        = $datos["Tipo"] ?? '';
    $cempresa_id  = $datos["Id_Empresa"] ?? 0;
    $cremitente_id  = $datos["Id_Rmte"] ?? 0;
    $_cestado     = $datos["Estado"] ?? 'NUEVO';

    // Enlazar parámetros
    $stmt->bindParam(1, $ctipodoc, PDO::PARAM_INT);
    $stmt->bindParam(2, $cdocidentidad, PDO::PARAM_STR);
    $stmt->bindParam(3, $cnombre, PDO::PARAM_STR);
    $stmt->bindParam(4, $cdireccion, PDO::PARAM_STR);
    $stmt->bindParam(5, $ctipo, PDO::PARAM_STR);
    $stmt->bindParam(6, $cempresa_id, PDO::PARAM_INT);
    $stmt->bindParam(7, $cremitente_id, PDO::PARAM_INT);
    $stmt->bindParam(8, $_cestado, PDO::PARAM_STR);

    $stmt->execute();
    $fila = $stmt->fetch(PDO::FETCH_ASSOC);
    $remitente_id = $fila['remitente_id'] ?? 0;

    if ($_cestado === "NUEVO") {
        if ($remitente_id > 0) {
            $conn->commit();
            $resultado = [
                "ESTADO" => "1",
                "ID" => $remitente_id,
                "MENSAJE" => "LA INFORMACIÓN GUARDÓ CORRECTAMENTE"
            ];
        } else {
            $conn->rollBack();
            $resultado = [
                "ESTADO" => "0",
                "ID" => "0",
                "MENSAJE" => "ERROR AL GUARDAR LA INFORMACIÓN"
            ];
        }
    } else {
        $conn->commit();
        $resultado = [
            "ESTADO" => "1",
            "ID" => $remitente_id,
            "MENSAJE" => "LA INFORMACIÓN ACTUALIZÓ CORRECTAMENTE"
        ];
    }

    http_response_code(200);
    echo json_encode($resultado, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    $conn->rollBack();
    $resultado = [
        "ESTADO" => "0",
        "ID" => "0",
        "MENSAJE" => "ERROR: " . $e->getMessage()
    ];
    http_response_code(500);
    echo json_encode($resultado, JSON_PRETTY_PRINT);
} finally {
    $conn = null;
}
?>