<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1], $datos[2], $datos[3])) {
        throw new Exception("Parámetros incompletos.");
    }

    $sql = "SELECT * FROM Buscar_Destinatario(:empresa_id, :sucursal_id, :docidentidad, :tipo_busqueda)";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':empresa_id'    => (int)$datos[0],
        ':sucursal_id'   => $datos[1],
        ':docidentidad'  => $datos[2],
        ':tipo_busqueda' => $datos[3]
    ]);

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}
?>
