<?php
error_reporting(E_ALL ^ E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos[0], $datos[1])) {
        throw new Exception("Parámetros incompletos.");
    }

    $sql = "SELECT documento_identidad FROM clientes WHERE empresa_id = :empresa_id AND documento_identidad = :docidentidad LIMIT 1";
    $stmt = $conn->prepare($sql);
    $stmt->execute([
        ':empresa_id'    => (int)$datos[0],
        ':docidentidad'  => $datos[1]
    ]);

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    print_json($rows);

} catch (Exception $e) {
    http_response_code(500);
    echo json_encode(['error' => $e->getMessage()], JSON_UNESCAPED_UNICODE);
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH: echo ' - Maximum stack depth exceeded'; break;
        case JSON_ERROR_STATE_MISMATCH: echo ' - Underflow or the modes mismatch'; break;
        case JSON_ERROR_CTRL_CHAR: echo ' - Unexpected control character found'; break;
        case JSON_ERROR_SYNTAX: echo ' - Syntax error, malformed JSON'; break;
        case JSON_ERROR_UTF8: echo ' - Malformed UTF-8 characters, possibly incorrectly encoded'; break;
        default: echo ' - Unknown error'; break;
    }
}
?>
