<?php
error_reporting(E_ALL ^ E_NOTICE);

// Permitir solicitudes desde cualquier origen
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-type: application/json; charset=utf-8");

// Incluir conexión a la base de datos
include_once '../conexion.php';

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

$response = [];

try {
    // Iniciar conexión con PostgreSQL
    $conn->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // Preparar y ejecutar el procedimiento almacenado
    $sql = "CALL UP_Venta(?, ?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($sql);

    // Vincular parámetros
    for ($i = 0; $i < 6; $i++) {
        $stmt->bindValue($i + 1, $datos[$i], PDO::PARAM_STR);
    }

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stmt->closeCursor();

    // Verificar si hay resultados
    if (!empty($rows)) {
        $response = $rows;
    }

} catch (PDOException $e) {
    $response['error'] = "ERROR: " . $e->getMessage();
}

// Cerrar conexión
$conn = null;

// Enviar respuesta JSON
echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>
