<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-type: application/json; charset=utf-8");

// Se incluye el archivo que contiene la conexión PDO
include_once '../conexion.php';

// Leer el cuerpo de la solicitud
$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

// Validar parámetros
if (!is_array($datos) || count($datos) < 3) {
    http_response_code(400); // Bad Request
    print_json(["error" => "Parámetros insuficientes."]);
    exit();
}

try {
    // Preparar llamada a función o procedimiento
    $stmt = $conn->prepare("SELECT * FROM Listar_Doc_x_Enviar(:empresa_id, :sucursal_id, :fecha)");

    // Asignar valores
    $stmt->bindValue(':empresa_id', $datos[0], PDO::PARAM_INT);
    $stmt->bindValue(':sucursal_id', $datos[1], PDO::PARAM_INT);
    $stmt->bindValue(':fecha', $datos[2], PDO::PARAM_STR);

    $stmt->execute();
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    print_json($rows);
} catch (PDOException $e) {
    http_response_code(500);
    print_json(["error" => $e->getMessage()]);
}

function print_json($data) {
    echo json_encode($data, JSON_UNESCAPED_UNICODE);

    switch (json_last_error()) {
        case JSON_ERROR_NONE: break;
        case JSON_ERROR_DEPTH: echo ' - Maximum stack depth exceeded'; break;
        case JSON_ERROR_STATE_MISMATCH: echo ' - Underflow or the modes mismatch'; break;
        case JSON_ERROR_CTRL_CHAR: echo ' - Unexpected control character found'; break;
        case JSON_ERROR_SYNTAX: echo ' - Syntax error, malformed JSON'; break;
        case JSON_ERROR_UTF8: echo ' - Malformed UTF-8 characters, possibly incorrectly encoded'; break;
        default: echo ' - Unknown error'; break;
    }
}
?>