<?php
error_reporting(E_ALL & ~E_NOTICE);
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-type: application/json; charset=utf-8");

include_once '../conexion.php';

$bodyRequest = file_get_contents("php://input");
$datos = json_decode($bodyRequest, true);

if (!isset($datos[0])) {
    http_response_code(400);
    echo json_encode(["error" => "ID de venta no especificado"]);
    exit;
}

$idVenta = $datos[0];

try {
    $sql = "SELECT numero_cuota, importe, fecha_pago 
            FROM cuotasclientes 
            WHERE venta_id = :venta_id 
            ORDER BY venta_id, numero_cuota ASC";

    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':venta_id', $idVenta, PDO::PARAM_INT);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode($rows, JSON_UNESCAPED_UNICODE);

} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(["error" => "Error en la consulta: " . $e->getMessage()]);
}
