<?php
error_reporting(E_ALL);

header("Access-Control-Allow-Methods: POST");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php';
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);
    
    if (!is_array($datos) || count($datos) < 3) {
        throw new Exception("Se requieren empresa_id, almacen_id y producto_id.");
    }
    
    $empresa_id  = (int)$datos[0];
    $almacen_id  = (int)$datos[1];
    $producto_id = (int)$datos[2];
    
    // Soporte retro: si vienen 3 => GENERAL.
    // Si vienen 6, usa filtros.
    $modo   = isset($datos[3]) ? (string)$datos[3] : 'GENERAL';
    $doc    = isset($datos[4]) ? (string)$datos[4] : '';
    $nombre = isset($datos[5]) ? (string)$datos[5] : '';
    
    $sql = "SELECT * 
            FROM consulta_kardex_producto(:empresa_id, :almacen_id, :producto_id, :modo, :doc, :nombre)";
    $stmt = $conn->prepare($sql);
    $stmt->bindValue(':empresa_id',  $empresa_id,  PDO::PARAM_INT);
    $stmt->bindValue(':almacen_id',  $almacen_id,  PDO::PARAM_INT);
    $stmt->bindValue(':producto_id', $producto_id, PDO::PARAM_INT);
    $stmt->bindValue(':modo',        $modo,        PDO::PARAM_STR);
    $stmt->bindValue(':doc',         $doc,         PDO::PARAM_STR);
    $stmt->bindValue(':nombre',      $nombre,      PDO::PARAM_STR);
    $stmt->execute();
    
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode($rows ?: [], JSON_UNESCAPED_UNICODE);
} catch (Exception $e) {
    http_response_code(500);
    echo json_encode([
        'error' => $e->getMessage()
    ], JSON_UNESCAPED_UNICODE);
} finally {
    $conn = null;
}
