<?php
header('Content-Type: application/json');

try {
    require_once '../conexion.php';
    include_once '../clases/TokenValidator.php';

    // Llama la validación antes de cualquier consulta
    $usuarioId = TokenValidator::validar($conn);

    $empresa_id = $_GET['empresa_id'] ?? null;
    $sucursal_id = $_GET['sucursal_id'] ?? null;
    $fecha = $_GET['fecha'] ?? null;

    if (!$empresa_id || !$sucursal_id || !$fecha) {
        throw new Exception("Faltan parámetros requeridos.");
    }

    $stmt = $conn->prepare("SELECT * FROM reporte_consolidado_despacho(:empresa_id, :sucursal_id, :fecha)");
    $stmt->execute([
        ':empresa_id' => $empresa_id,
        ':sucursal_id' => $sucursal_id,
        ':fecha' => $fecha
    ]);

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'estado' => 'OK',
        'data' => $data
    ]);

} catch (Exception $e) {
    echo json_encode([
        'estado' => 'ERROR',
        'mensaje' => $e->getMessage()
    ]);
}
?>
