<?php
error_reporting(E_ALL ^ E_NOTICE);

header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE");
header("Content-Type: application/json; charset=utf-8");

include_once '../conexion.php'; 
include_once '../clases/TokenValidator.php';

// Llama la validación antes de cualquier consulta
$usuarioId = TokenValidator::validar($conn);

try {
    // Leer y decodificar el cuerpo JSON
    $bodyRequest = file_get_contents("php://input");
    $datos = json_decode($bodyRequest, true);

    if (!isset($datos['condicion']) || trim($datos['condicion']) === '') {
        throw new Exception("Falta la condición del filtro");
    }
    
    $condicion = $datos['condicion'];

    // Consulta a la función PostgreSQL
    $sql = "SELECT * FROM informe_compras(:condicion)";
    $stmt = $conn->prepare($sql);
    $stmt->bindParam(':condicion', $condicion, PDO::PARAM_STR);
    $stmt->execute();

    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // ✅ Si no hay resultados, devolver un array vacío
    if (!$rows) {
        echo json_encode([], JSON_UNESCAPED_UNICODE);
    } else {
        echo json_encode($rows, JSON_UNESCAPED_UNICODE);
    }

} catch (PDOException $e) {
    error_response("Error en la base de datos: " . $e->getMessage());
} catch (Exception $e) {
    error_response("Error: " . $e->getMessage());
}

// Función de error estructurada
function error_response($message) {
    http_response_code(500);
    echo json_encode(['estado' => 'error', 'mensaje' => $message], JSON_UNESCAPED_UNICODE);
    exit();
}
?>